<!DOCTYPE html>
<html>
<head>
  <style>
    body { font-family: sans-serif; font-size: 12px; }
    table { width: 100%; border-collapse: collapse; margin-top: 10px; }
    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
    th { background-color: #f2f2f2; }
    table {
    border-spacing: 0;
    overflow: wrap;
    min-width: 100%;
}
table tr td {
    margin: 0px;
}
  </style>
</head>
<body>
  <h2>Invoice #<?php (isset($taxInvoiceData[0]->invoice_number) && !empty($taxInvoiceData[0]->invoice_number)) ? print_r($taxInvoiceData[0]->invoice_number) : print_r('-');?></h2>
  <p>Date: <?php echo $taxInvoiceData[0]->invoice_date; ?></p>
  <p>Billed To: <?php echo $taxInvoiceData[0]->customer_name ?? "-"; ?></p>


        
     <?php
     $layoutConfig = json_decode($taxInvoiceData[0]->layout_json, true);  // from DB
$lineItems = json_decode($taxInvoiceData[0]->default_line_items, true); // from DB
$visibleColumns = array_filter($layoutConfig['columns'], fn($col) => $col['visible']);

// === Table Header
echo "<table style='width: 100%; border-collapse: collapse;' border='1'>";
echo "<thead><tr>";
foreach ($visibleColumns as $col) {
    echo "<th style='padding: 6px; text-align: {$col['align']};'>" . htmlspecialchars($col['name']) . "</th>";
}
echo "</tr></thead>";

// === Table Body
echo "<tbody>";
foreach ($lineItems as $row) {
    echo "<tr>";
    foreach ($visibleColumns as $col) {
        $colId = $col['id'];
        $value = isset($row[$colId]) ? $row[$colId] : '';
        
        // Optional: Format numbers for formula/tax fields
        if (in_array($col['type'], ['NUMBER', 'FORMULA', 'TAX_FIELD']) && is_numeric($value)) {
            $value = number_format((float) $value, 2);
        }

        echo "<td style='padding: 6px; text-align: {$col['align']};'>" . htmlspecialchars($value) . "</td>";
    }
    echo "</tr>";
}
echo "</tbody></table>";
?>
    

  <h3>Total:<?php echo $taxInvoiceData[0]->invoice_total; ?></h3>
</body>
</html>
