<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// If your vendor path differs, adjust this require:
require_once APPPATH . '../vendor/autoload.php';

class MPDFCI extends \Mpdf\Mpdf
{
    public function __construct($params = [])
    {
        // Create a dedicated temp/cache directory for mPDF (reduces RAM usage)
        $mpdfTemp = APPPATH . 'cache/mpdf';
        if (!is_dir($mpdfTemp)) {
            @mkdir($mpdfTemp, 0775, true);
        }

        $defaults = [
		  'mode'          => 'utf-8',
		  'format'        => 'A4',
		  'margin_left'   => 10, 'margin_right' => 10,
		  'margin_top'    => 10, 'margin_bottom'=> 10,
		  'tempDir'       => APPPATH.'cache/mpdf',
		  'cacheDir'      => APPPATH.'cache/mpdf',
		  'packTableData' => true,
		  // Optional further savings:
		  // 'default_font'   => 'dejavusans', // or a lighter Latin font you ship
		  // 'autoScriptToLang' => false,
		  // 'autoLangToFont'   => false,
		];
		parent::__construct($defaults);
		$this->simpleTables     = true;    // cheaper table engine
		$this->useSubstitutions = false;   // avoid heavy font fallback
		$this->img_dpi          = 96;      // harmless even if no images
		$this->use_kwt          = false;   // relax keep-with-table logic
		$this->keep_table_proportions = true;
		$this->SetCompression(true);
    }
}
