<?php
defined('BASEPATH') or exit('No direct script access allowed');

class DynamicFormField extends CI_Controller
{

    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     *         http://example.com/index.php/welcome
     *    - or -
     *         http://example.com/index.php/welcome/index
     *    - or -
     * Since this controller is set as the default controller in
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see https://codeigniter.com/user_guide/general/urls.html
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('CommonModel');
        $this->load->library("pagination");
        $this->load->library("response");
        $this->load->library("ValidateData");
        $this->load->library("Datatables");
    }
    public function formFieldList()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $method = $this->input->method(true);

        // $this->access->checkTokenKey();
        // $this->response->decodeRequest();
        $textSearch = $this->input->post('textSearch');
        $isAll = $this->input->post('getAll');
        $curPage = $this->input->post('curpage');
        $textval = $this->input->post('textval');
        $menuId = $this->input->post('menuId');
        $orderBy = $this->input->post('orderBy');
        $order = $this->input->post('order');

        $statuscode = $this->input->post('status');
        $config = array();
        if (!isset($orderBy) || empty($orderBy)) {
            $orderBy = "created_date";
            $order = "DESC";
        }
        $other = array("orderBy" => $orderBy, "order" => $order);

        $config = $this->config->item('pagination');
        $wherec = $join = array();
        if (isset($textSearch) && !empty($textSearch) && isset($textval) && !empty($textval)) {
            $wherec["$textSearch like  "] = "'" . $textval . "%'";
        }
        if (isset($menuId) && !empty($menuId)) {
            $wherec["menuId"] = "='" . $menuId . "'";
        }

        if (isset($statuscode) && !empty($statuscode)) {
            $statusStr = str_replace(",", '","', $statuscode);
            $wherec["status"] = 'IN ("' . $statusStr . '")';
        }

        $config["base_url"] = base_url() . "dynamicFormFieldDetails";
        $config["total_rows"] = $this->CommonModel->getCountByParameter('fieldID', 'dynamic_fields', $wherec);
        $config["uri_segment"] = 2;
        $this->pagination->initialize($config);
        if (isset($curPage) && !empty($curPage)) {
            $curPage = $curPage;
            $page = $curPage * $config["per_page"];
        } else {
            $curPage = 0;
            $page = 0;
        }
        if ($isAll == "Y") {
            $dynamicFeildsDetails = $this->CommonModel->GetMasterListDetails($selectC = '', 'dynamic_fields', $wherec, '', '', $join, $other);
        } else {
            $dynamicFeildsDetails = $this->CommonModel->GetMasterListDetails($selectC = '', 'dynamic_fields', $wherec, $config["per_page"], $page, $join, $other);
        }
        if (!empty($dynamicFeildsDetails)) {
            // 1) collect eligible field IDs
            $eligibleTypes = ['radiolist','checkboxlist','dropdown'];
            $fieldIds = [];

            foreach ($dynamicFeildsDetails as $row) {
                $type = strtolower(trim($row->fieldType ?? $row->type ?? ''));
                if (in_array($type, $eligibleTypes, true)) {
                    if (!empty($row->fieldID)) {
                        $fieldIds[] = (int)$row->fieldID;
                    }
                }
            }
            $fieldIds = array_values(array_unique(array_filter($fieldIds)));

            // 2) fetch options in one go
            $optsByField = [];
            if (!empty($fieldIds)) {
                $optWhere = [];
                // NOTE: adapt the table/column names to your schema
                // table: ab_dynamic_feilds_option  (use your actual name)
                // columns assumed: id, field_id, label, value_key, sort_order, is_active
                $optWhere['field_id'] = 'IN (' . implode(',', $fieldIds) . ')';
                // If you have an is_active column, keep only active options
                $optWhere['is_active'] = '= 1';

                $optOther = ['orderBy' => 'sort_order, label', 'order' => 'ASC'];
                $options = $this->CommonModel->GetMasterListDetails(
                    $selectC = '',
                    'dynamic_field_options', // <-- adjust if your table name differs
                    $optWhere,
                    '', '', /* limit, offset */
                    $join = [],
                    $optOther
                );

                if (!empty($options)) {
                    foreach ($options as $opt) {
                        $fid   = (int)($opt->field_id ?? 0);
                        // pick a stable key (id preferred; fall back to value_key)
                        $key   = $opt->id ?? $opt->value_key ?? null;
                        $label = $opt->label ?? $opt->value ?? $opt->value_key ?? null;
                        if ($fid && $key !== null && $label !== null) {
                            $optsByField[$fid][] = [
                                'value'   => (string)$key,
                                'label' => (string)$label,
                            ];
                        }
                    }
                }
            }
            foreach ($dynamicFeildsDetails as &$row) {
                $fid  = (int)($row->fieldID ?? 0);
                $type = strtolower(trim($row->fieldType ?? $row->type ?? ''));
                if ($fid && in_array($type, $eligibleTypes, true)) {
                    $row->fieldOptions = $optsByField[$fid] ?? [];
                } else {
                    $row->fieldOptions = []; // keep shape predictable
                }
            }
            unset($row);
        }
        $status['data'] = $dynamicFeildsDetails;
        $status['paginginfo']["curPage"] = $curPage;
        if ($curPage <= 1) {
            $status['paginginfo']["prevPage"] = 0;
        } else {
            $status['paginginfo']["prevPage"] = $curPage - 1;
        }

        $status['paginginfo']["pageLimit"] = $config["per_page"];
        $status['paginginfo']["nextpage"] = $curPage + 1;
        $status['paginginfo']["totalRecords"] = $config["total_rows"];
        $status['paginginfo']["start"] = $page;
        $status['paginginfo']["end"] = $page + $config["per_page"];
        $status['loadstate'] = true;
        if ($config["total_rows"] <= $status['paginginfo']["end"]) {
            $status['msg'] = $this->systemmsg->getErrorCode(232);
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $status['loadstate'] = false;
            $this->response->output($status, 200);
        }
        if ($dynamicFeildsDetails) {
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    public function dynamicformfield($id = '')
    {
        $this->response->decodeRequest();
        $method = $this->input->method(true);
        $action = $this->input->post('action');
        $fields = array();
        $menuId = $this->input->post('menuId');
        $this->db->trans_start();
        if ($action != "" && $action == "DELETE") {
            $method = "DELETE";
        }

        if ($method == "PUT" || $method == "POST") {
            $fieldDetails = array();
            $updateDate = date("Y/m/d H:i:s");
            $fieldDetails['fieldLabel'] = $this->validatedata->validate('fieldLabel', 'Field Label', true, '', array());
            $fieldDetails['fieldType'] = $this->validatedata->validate('fieldType', 'Field Type', true, '', array());
            $fieldDetails['placeholder'] = $this->validatedata->validate('placeholder', 'Placeholder', false, '', array());
            $fieldDetails['defaultValue'] = $this->validatedata->validate('defaultValue', 'Default Value', false, '', array());
            if ($fieldDetails['defaultValue'] == "NULL") {
                $fieldDetails['defaultValue'] = null;
            }
            $fieldDetails['fieldOptions'] = $this->validatedata->validate('fieldOptions', 'Field Options', false, '', array());
            $fieldDetails['tooltip'] = $this->validatedata->validate('tooltip', 'Tooltip', false, '', array());
            $fieldDetails['isRequired'] = $this->validatedata->validate('isRequired', 'Is Required', false, '', array());
            $fieldDetails['allowMultiSelect'] = $this->validatedata->validate('allowMultiSelect', 'Allow Multi Select', false, '', array());
            $fieldDetails['minLength'] = $this->validatedata->validate('minLength', 'Min Length', false, '', array());
            $fieldDetails['maxLength'] = $this->validatedata->validate('maxLength', 'Max Length', false, '', array());
            $fieldDetails['startDate'] = $this->validatedata->validate('startDate', 'Start Date', false, '', array());
            $fieldDetails['parentCategory'] = $this->validatedata->validate('parentCategory', 'Parent Category', false, '', array());
            $fieldDetails['icon_name'] = $this->validatedata->validate('icon_name', 'Icon Name', false, '', array());
            if (!empty($fieldDetails['startDate'])) {
                $fieldDetails['startDate'] = date("Y-m-d", strtotime($fieldDetails['startDate']));
            }
            $fieldDetails['endDate'] = $this->validatedata->validate('endDate', 'End Date', false, '', array());
            if (!empty($fieldDetails['endDate'])) {
                $fieldDetails['endDate'] = date("Y-m-d", strtotime($fieldDetails['endDate']));
            }

            $fieldDetails['dateFormat'] = $this->validatedata->validate('dateFormat', 'Date Format', false, '', array());
            //$fieldDetails['supportedFileTypes'] = $this->validatedata->validate('supportedFileTypes', 'Supported File Types', false, '', array());
            if ($fieldDetails['fieldType'] == "File") {
                $fieldDetails['supportedFileTypes'] = $_POST['supportedFileTypes']; //$this->validatedata->validate('supportedFileTypes', 'Supported File Types', true, '', array());
                if ($_POST['supportedFileTypes'] == "") {
                    $status['data'] = array();
                    $status['msg'] = "supported File Type Required";
                    $status['statusCode'] = 227;
                    $status['flag'] = 'F';
                    $this->response->output($status, 200);
                } else {
                    $fieldDetails['supportedFileTypes'] = implode(",", $_POST['supportedFileTypes']);
                }
                $fieldDetails['numberOfFileToUpload'] = $this->validatedata->validate('numberOfFileToUpload', 'Number Of File To Upload', true, '', array());
            }
            $fieldDetails['validationRules'] = $this->validatedata->validate('validationRules', 'Validation Rules', false, '', array());
            $fieldDetails['startTime'] = $this->validatedata->validate('startTime', 'Start Time', false, '', array());
            $fieldDetails['endTime'] = $this->validatedata->validate('endTime', 'End Time', false, '', array());
            $fieldDetails['displayFormat'] = $this->validatedata->validate('displayFormat', 'Display Format', false, '', array());
            $fieldDetails['minRangeValue'] = $this->validatedata->validate('minRangeValue', 'Min Range', false, '', array());
            $fieldDetails['maxRangeValue'] = $this->validatedata->validate('maxRangeValue', 'Max Range', false, '', array());
            $fieldDetails['stepSize'] = $this->validatedata->validate('stepSize', 'Step Size', false, '', array());
            $fieldDetails['fieldIndex'] = $this->validatedata->validate('fieldIndex', 'Field Index', false, '', array());
            $fieldDetails['status'] = $this->validatedata->validate('status', 'Status', true, '', array());
            $fieldDetails['valDefault'] = $this->validatedata->validate('valDefault', 'Default Value', false, '', array());
            $fieldDetails['isNull'] = $this->validatedata->validate('isNull', 'Null', false, '', array());
            $fieldDetails['menuId'] = $this->validatedata->validate('menuId', 'Module', true, '', array());
            $fieldDetails['itemAlign'] = $this->validatedata->validate('itemAlign', 'Display Items', false, '', array());
            $fieldDetails['textareaType'] = $this->validatedata->validate('textareaType', 'Display Textarea', false, '', array());
            $fieldDetails['linkedWith'] = $this->validatedata->validate('linkedWith', 'Linked With', false, '', array());
            $fieldDetails['linked_with_name'] = $this->validatedata->validate('linked_with_name', 'Linked With Name', false, '', array());
            
            if(isset($fieldDetails['linkedWith']) && !empty($fieldDetails['linkedWith'])){
                $fieldDetails['linkedDisplayColumn'] = $this->validatedata->validate('linkedDisplayColumn', 'Linked Module Column Name', true, '', array());
                $fieldDetails['source_type'] = "linked_table";
            }
            $fieldDetails['date_selection_criteria'] = $this->validatedata->validate('date_selection_criteria', 'Select Date Criteria', false, '', array());
        }
        
        switch ($method) {
            case "PUT":{
                    $fieldDetails['column_name'] = str_replace(" ", "_", strtolower($fieldDetails['fieldLabel']));
                    // if ($fieldDetails['valDefault'] == "USER_DEFINED") {
                    //     $userDef = $this->validatedata->validate('defaultValue', 'Default Value', true, '', array());
                    //     $fieldDetails['valDefault'] = $userDef;
                    //     $fields[$fieldDetails['column_name']]['default'] = $fieldDetails['valDefault'];
                    // } elseif ($fieldDetails['valDefault'] == "NONE") {
                    //     $fields[$fieldDetails['column_name']]['null'] = null;
                    // }
                    $menuId = $fieldDetails['menuId'];
                    $where = array('menuId' => $menuId);
                    $tabNameMenu = $this->CommonModel->getMasterDetails('menu_master', '', $where);
                    $tabName = $tabNameMenu[0]->table_name; //$fieldDetails['table_name'];
                    //$menulink = $tabNameMenu[0]->menuLink;
                    // change this to menu id as we can edit the name of the link and it will affect the exiting created dynamic table
                    $menulink = $tabNameMenu[0]->menuID;
                    $vtype = $fieldDetails['fieldType'];

                    $fieldDetails['modified_by'] = $this->input->post('SadminID');
                    $fieldDetails['created_by'] = $this->input->post('SadminID');
                    $fieldDetails['created_date'] = $updateDate;
                   
                    $iscreated = $this->CommonModel->saveMasterDetails('dynamic_fields', $fieldDetails);
                    
                    $fieldId = $this->db->insert_id(); // we need the new fieldID
                    $isOptionField = in_array(strtolower($vtype), ['dropdown','radiolist','checkboxlist'], true);
                    $isLinked      = !empty($fieldDetails['linkedWith']); // when linked to another table
                    $isMulti       = (strtolower($vtype) === 'checkboxlist') || ($fieldDetails['allowMultiSelect'] === 'yes');
 
                    // For option-based fields:
                    //  - Do NOT add a VARCHAR column to dynamic tables
                    //  - If local list (not linked), populate options catalog
                    if ($isOptionField) {
                        // Save a hint in dynamic_fields (optional but useful downstream)
                        $this->CommonModel->updateMasterDetails('dynamic_fields', [
                            'allowMultiSelect' => $isMulti ? 'yes' : 'no',
                        ], ['fieldID' => $fieldId]);

                        if (!$isLinked) {
                            // From builder’s CSV `fieldOptions` (or array), write to options catalog
                            $this->sync_field_options($fieldId, $fieldDetails['fieldOptions']);
                        }
                        // IMPORTANT: skip all DDL for adding a column for this field
                        // (return success immediately after transaction)
                        if ($this->db->trans_status() === false) {
                            $this->db->trans_rollback();
                            $status = ['msg'=>$this->systemmsg->getErrorCode(998),'statusCode'=>998,'data'=>[],'flag'=>'F'];
                        } else {
                            $this->db->trans_commit();
                            $status = ['msg'=>$this->systemmsg->getSucessCode(400),'statusCode'=>400,'data'=>[],'flag'=>'S'];
                        }
                        // $this->response->output($status, 200);
                        // return; // ← prevent falling through to DDL logic
                    }

                    
                    //$fieldDetails['fieldLabel']  = str_replace(" ","_",strtolower($fieldDetails['fieldLabel']));
                    //BLOB, TEXT, GEOMETRY or JSON
                    //$fields[$fieldDetails['column_name']]['null'] = $fieldDetails['isNull'];
                    if (isset($fieldDetails['isRequired']) && !empty($fieldDetails['isRequired']) && $fieldDetails['isRequired'] == "yes") {
                        $fields[$fieldDetails['column_name']]['default'] = "None";
                        //$fields[$fieldDetails['column_name']]['null'] = FALSE;
                    }
                    switch ($vtype) {
                        case 'Textarea':
                            $fields[$fieldDetails['column_name']]['type'] = 'TEXT';
                            unset($fields[$fieldDetails['column_name']]['default']);
                            if ($fieldDetails['textareaType'] == "simpleTextarea") {
                                $fields[$fieldDetails['column_name']]['type'] = 'TINYTEXT';
                            }
                            break;
                        case 'Numeric':
                            if ($fieldDetails['maxLength'] == 0 || $fieldDetails['maxLength'] == "") {
                                $fieldDetails['maxLength'] = 11;
                            }

                            $fieldDetails['numType'] = $this->validatedata->validate('numType', 'Number Type', true, '', array());
                            $fields[$fieldDetails['column_name']]['type'] = $fieldDetails['numType'];
                            $fields[$fieldDetails['column_name']]['constraint'] = strlen($fieldDetails['maxLength']);
                            break;
                        case 'Datepicker':
                            $fields[$fieldDetails['column_name']]['type'] = 'DATE';
                            $fields[$fieldDetails['column_name']]['null'] = true;

                            break;
                        case 'Timepicker':
                            $fields[$fieldDetails['column_name']]['type'] = 'TIME';
                            break;
                        // case 'Textbox':
                        // case 'File':
                        // case 'Dropdown':
                        // case 'RadioList':
                        // case 'CheckboxList':
                        // case 'Password':
                        // case 'Timepicker':
                        default:
                            if ($fieldDetails['maxLength'] == 0 || $fieldDetails['maxLength'] == "") {
                                $fieldDetails['maxLength'] = 300;
                            }

                            $fields[$fieldDetails['column_name']]['type'] = 'VARCHAR';
                            $fields[$fieldDetails['column_name']]['constraint'] = $fieldDetails['maxLength'];
                    }
                    
                    // check if created feild is exiting in current table
                    if ($tabNameMenu[0]->custom_module == 'no') {
                        
                        if (!$this->datatables->check_table_exist($menulink)) {
                            $this->datatables->create_table($menulink, $fields);
                            // $this->datatables->add_column('dynamic_' . $menulink, $primaryVal);
                        } else {
                            
                            $this->datatables->add_column($menulink, $fields);
                        }
                    }else{
                        
                        if (!$this->datatables->check_table_exist('dynamic_' . $menulink)) {
                            $primaryVal = $this->datatables->getPrimaryKey($tabName);
                            $fields = array_merge($fields, $primaryVal);
                            $this->datatables->create_table('dynamic_' . $menulink, $fields);
                            $this->datatables->add_column('dynamic_' . $menulink, $fields,$tabName);
                        } else {
                            $this->datatables->add_column('dynamic_' . $menulink, $fields,$tabName);
                        }
                    }
                    if ($this->db->trans_status() === false) {
                        $this->db->trans_rollback();
                        $status['msg'] = $this->systemmsg->getErrorCode(998);
                        $status['statusCode'] = 998;
                        $status['data'] = array();
                        $status['flag'] = 'F';
                        $this->response->output($status, 200);
                    } else {
                        $this->db->trans_commit();
                        $status['msg'] = $this->systemmsg->getSucessCode(400);
                        $status['statusCode'] = 400;
                        $status['data'] = array();
                        $status['flag'] = 'S';
                        $this->response->output($status, 200);
                    }
                    break;
                }

            case "POST":{
                    //$fieldDetails = array();
                    if ($fieldDetails['valDefault'] == "USER_DEFINED") {
                        $userDef = $this->validatedata->validate('defaultValue', 'Default Value', true, '', array());
                        $fieldDetails['valDefault'] = $userDef;
                        $fields[$fieldDetails['column_name']]['default'] = $fieldDetails['valDefault'];
                    } elseif ($fieldDetails['valDefault'] == "NONE") {
                        $fields[$fieldDetails['column_name']]['null'] = null;
                    }
                    $vtype = $fieldDetails['fieldType'];


                    $updateDate = date("Y/m/d H:i:s");
                    $wheredyn = array('fieldID' => $id);
                    if (!isset($id) || empty($id)) {
                        $status['msg'] = $this->systemmsg->getErrorCode(998);
                        $status['statusCode'] = 998;
                        $status['data'] = array();
                        $status['flag'] = 'F';
                        $this->response->output($status, 200);
                    }
                    //$fieldDetails['table_name'] = $this->validatedata->validate('table_name', 'Table Name', true, '', array());
                    $fieldDetails['modified_by'] = $this->input->post('SadminID');
                    $oldTabData = $this->CommonModel->getMasterDetails('dynamic_fields', '', $wheredyn);
                    //print_r($fieldDetails);
                    $fieldlableold = $oldTabData[0]->column_name;
                    $fieldDetails['column_name'] = str_replace(" ", "_", strtolower($fieldDetails['fieldLabel']));
                    $iscreated = $this->CommonModel->updateMasterDetails('dynamic_fields', $fieldDetails, $wheredyn);
                    $isOptionField = in_array(strtolower($vtype), ['dropdown','radiolist','checkboxlist'], true);
                    //$isOptionField = in_array($vtype, ['Dropdown','RadioList','CheckboxList'], true);
                    $isLinked      = !empty($fieldDetails['linkedWith']);
                    $isMulti       = (strtolower($vtype) === 'checkboxlist') || ($fieldDetails['allowMultiSelect'] === 'yes');

                    if ($isOptionField) {
                        // Persist the multi flag (optional)
                        $this->CommonModel->updateMasterDetails('dynamic_fields', [
                            'allowMultiSelect' => $isMulti ? 'yes' : 'no',
                        ], $wheredyn);

                        if (!$isLinked) {
                            // Re-sync the options catalog (CSV may have changed)
                            $this->sync_field_options($id, $fieldDetails['fieldOptions']);
                        }

                        // SKIP modify_column for option fields (no VARCHAR column for them)
                        if ($this->db->trans_status() === false) {
                            $this->db->trans_rollback();
                            $status = ['msg'=>$this->systemmsg->getErrorCode(998),'statusCode'=>998,'data'=>[],'flag'=>'F'];
                        } else {
                            $this->db->trans_commit();
                            $status = ['msg'=>$this->systemmsg->getSucessCode(400),'statusCode'=>400,'data'=>[],'flag'=>'S'];
                        }
                        $this->response->output($status, 200);
                        return;
                    }
                    
                    $menuId = $fieldDetails['menuId'];
                    $wheremnu = array('menuId' => $menuId);
                    $tabNameMenu = $this->CommonModel->getMasterDetails('menu_master', '', $wheremnu);
                    $tabName = $tabNameMenu[0]->table_name;
                    $menulink = $tabNameMenu[0]->menuLink;
                    //$tabName = $fieldDetails['table_name'];
                    //$fieldDetails['fieldLabel']  = str_replace(" ","_",strtolower($fieldDetails['fieldLabel']));

                    // if(isset($fieldDetails['valDefault']) && !empty($fieldDetails['valDefault'])){
                    //     $fields[$fieldDetails['column_name']]['default'] = $fieldDetails['valDefault'];
                    // }
                    $fields[$fieldDetails['column_name']]['null'] = $fieldDetails['isNull'];
                    if (isset($fieldDetails['isRequired']) && !empty($fieldDetails['isRequired']) && $fieldDetails['isRequired'] == "yes") {
                        $fields[$fieldDetails['column_name']]['default'] = "None";
                        $fields[$fieldDetails['column_name']]['null'] = false;
                    }

                    switch ($vtype) {
                        case 'Textarea':
                            $fields[$fieldDetails['column_name']]['type'] = 'TEXT';
                            unset($fields[$fieldDetails['column_name']]['default']);
                            if ($fieldDetails['textareaType'] == "simpleTextarea") {
                                $fields[$fieldDetails['column_name']]['type'] = 'TINYTEXT';
                            }
                            break;
                        case 'Numeric':
                            if ($fieldDetails['maxLength'] == 0 || $fieldDetails['maxLength'] == "") {
                                $fieldDetails['maxLength'] = 11;
                            }

                            $fieldDetails['numType'] = $this->validatedata->validate('numType', 'Number Type', true, '', array());
                            $fields[$fieldDetails['column_name']]['type'] = $fieldDetails['numType'];
                            $fields[$fieldDetails['column_name']]['constraint'] = strlen($fieldDetails['maxLength']);
                            break;
                        case 'Datepicker':
                            $fields[$fieldlableold]['type'] = 'DATE';
                            break;
                        case 'Timepicker':
                            $fields[$fieldlableold]['type'] = 'TIME';
                            break;
                        default:
                            if ($fieldDetails['maxLength'] == 0 || $fieldDetails['maxLength'] == "") {
                                $fieldDetails['maxLength'] = 300;
                            }

                            $fields[$fieldlableold]['type'] = 'VARCHAR';
                            $fields[$fieldlableold]['constraint'] = $fieldDetails['maxLength'];
                    }
                    if ($tabNameMenu[0]->custom_module == 'no') {
                        $this->datatables->modify_column($menulink, $fields);
                    }else{
                        $this->datatables->modify_column('dynamic_' . $menulink, $fields);
                    }
                    if ($this->db->trans_status() === false) {
                        $this->db->trans_rollback();
                        $status['msg'] = $this->systemmsg->getErrorCode(998);
                        $status['statusCode'] = 998;
                        $status['data'] = array();
                        $status['flag'] = 'F';
                        $this->response->output($status, 200);
                    } else {
                        $this->db->trans_commit();
                        $status['msg'] = $this->systemmsg->getSucessCode(400);
                        $status['statusCode'] = 400;
                        $status['data'] = array();
                        $status['flag'] = 'S';
                        $this->response->output($status, 200);
                    }
                    break;
                }
            case "DELETE":{
                    $this->db->trans_start();
                    $fieldDetails = array();
                    $fieldDetails['idsToRemove'] = $this->input->post('list');
                    $fieldDetails['menuId'] = $this->input->post('menuId');
                    $iscreated = "";
                    if ($id != "") {
                        $where = array('fieldID' => $id);
                        if (!isset($id) || empty($id)) {
                            $status['msg'] = $this->systemmsg->getErrorCode(996);
                            $status['statusCode'] = 996;
                            $status['data'] = array();
                            $status['flag'] = 'F';
                            $this->response->output($status, 200);
                        }
                        // get the column name from tabel
                        $isExits = $this->CommonModel->getMasterDetails('dynamic_fields','column_name',array("fieldID"=>$id));
                        if(isset($isExits) && !empty($isExits)){
                            $this->datatables->remove_column('dynamic_fields',$isExits[0]->column_name);
                            $iscreated = $this->CommonModel->deleteMasterDetails('dynamic_fields', $where);
                        }else{
                            $iscreated = false;
                        }
                    }
                    if ($this->db->trans_status() === false) {
                            $this->db->trans_rollback();
                            $status['msg'] = $this->systemmsg->getErrorCode(996);
                            $status['statusCode'] = 996;
                            $status['data'] = array();
                            $status['flag'] = 'F';
                            $this->response->output($status, 200);
                    }else{
                        $this->db->trans_commit();
                    }
                    if (!$iscreated) {
                        $status['msg'] = $this->systemmsg->getErrorCode(996);
                        $status['statusCode'] = 996;
                        $status['data'] = array();
                        $status['flag'] = 'F';
                        $this->response->output($status, 200);
                    } else {
                        $status['msg'] = $this->systemmsg->getSucessCode(400);
                        $status['statusCode'] = 400;
                        $status['data'] = array();
                        $status['flag'] = 'S';
                        $this->response->output($status, 200);
                    }
                    break;
                }
            default:{
                    $where = array("fieldID" => $id);
                    $menuHistory = $this->CommonModel->getMasterDetails('dynamic_fields', '', $where);
                    if (isset($menuHistory) && !empty($menuHistory)) {
                        $status['data'] = $menuHistory;
                        $status['statusCode'] = 200;
                        $status['flag'] = 'S';
                        $this->response->output($status, 200);
                    } else {
                        $status['msg'] = $this->systemmsg->getErrorCode(227);
                        $status['statusCode'] = 227;
                        $status['data'] = array();
                        $status['flag'] = 'F';
                        $this->response->output($status, 200);
                    }
                    break;
                }
        }
    }
    
    public function getMenuDetails($menuId)
    {
        $wheredata["menuID"] = $menuId;
        $menuDetails = $this->CommonModel->getMasterDetails("menu_master", "menuLink", $wheredata);
        return $menuDetails;
    }
    public function changeStatus()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $action = $this->input->post("action");
        if (trim($action) == "changeStatus") {
            $ids = $this->input->post("list");
            $statusCode = $this->input->post("status");
            $this->db->trans_start();
            $changestatus = $this->CommonModel->changeMasterStatus('dynamic_fields', $statusCode, $ids, 'fieldID');
            if ($changestatus) {
                $idlist = explode(",", $ids);
                for ($i = 0; $i < count($idlist); $i++) {
                    $id = $idlist[$i];
                    $where = array('fieldID' => $id);
                    $menuHistory = $this->CommonModel->getMasterDetails('dynamic_fields', '', $where);
                    if (isset($menuHistory) && !empty($menuHistory)) {
                        $fieldLabel = $menuHistory[0]->column_name;
                        $menuId = $menuHistory[0]->menuID;
                        $whereMenu = array('menuId' => $menuId);
                        $tabNameMenu = $this->CommonModel->getMasterDetails('menu_master', '', $whereMenu);
                        $tabName = 'dynamic_'.$tabNameMenu[0]->menuID;
                        if ($this->datatables->check_field_exists($tabName, $menuHistory[0]->column_name)) {
                            $iscreated = $this->datatables->remove_column('dynamic_'.$tabNameMenu[0]->menuID, $fieldLabel);
                        }
                        $this->CommonModel->deleteMasterDetails("dynamic_fields", $where);
                        // deleted added columns as well for all iser custom table.
                        $allUserData = $this->CommonModel->getMasterDetails('user_column_data','',array("menu_id"=>$menuId));
                        foreach ($allUserData as $key => $value) {
                            
                            $columnsToRemove[] = $menuHistory[0]->column_name; // Add all column_names to remove
                            if($value->m_metadata != NUll){ 
                                $colData = json_decode($value->c_metadata,true);

                                $filtered = array_filter($colData, function ($item) use ($columnsToRemove) {
                                    return !in_array($item['column_name'], $columnsToRemove);
                                });// Re-index array if needed
                                $filtered = array_values($filtered);
                                $metadatDetails['c_metadata'] = json_encode($filtered);
                            }
                          

                            if($value->m_metadata != NUll){
                                $colDataM = json_decode($value->m_metadata,true);
                                $filtered_m = array_filter($colDataM, function ($item) use ($columnsToRemove) {
                                    return !in_array($item['column_name'], $columnsToRemove);
                                });// Re-index array if needed
                                $filtered_m = array_values($filtered_m);
                                $metadatDetails['m_metadata'] = json_encode($filtered_m);
                            }
                            
                            
                            if(isset($metadatDetails) && !empty($metadatDetails)){
                                $iscreated = $this->CommonModel->updateMasterDetails('user_column_data', $metadatDetails,array("record_id"=>$value->record_id)); 
                            }
                           //if($fieldLabel)
                        }
                    }
                }
                if ($this->db->trans_status() === false) {
                    $this->db->trans_rollback();
                    $status['data'] = array();
                    $status['msg'] = $this->systemmsg->getErrorCode(996);
                    $status['statusCode'] = 996;
                    $status['flag'] = 'F';
                    $this->response->output($status, 200);
                } else {
                    $this->db->trans_commit();
                    $status['data'] = array();
                    $status['statusCode'] = 200;
                    $status['flag'] = 'S';
                    $this->response->output($status, 200);
                }
            } else {
                $status['data'] = array();
                $status['msg'] = $this->systemmsg->getErrorCode(996);
                $status['statusCode'] = 996;
                $status['flag'] = 'F';
                $this->response->output($status, 200);
            }
        }
    }
    public function getFormData()
    {
        $this->response->decodeRequest();
        $form = $this->input->post('pluginName');
        $loadFrom = $this->input->post('loadFrom');
        $pluginId = $this->input->post('pluginId');
        if (!isset($form) && !isset($pluginId)) {
            $status['msg'] = $this->systemmsg->getErrorCode(280);
            $status['statusCode'] = 280;
            $status['data'] = array();
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
        $join = $other = array();
        $join[0]['type'] = "LEFT JOIN";
        $join[0]['table'] = "dynamic_fields";
        $join[0]['alias'] = "d";
        $join[0]['key1'] = "menuID";
        $join[0]['key2'] = "menuID";

        $dynamicFieldHtml = "";
        if (isset($pluginId) && !empty($pluginId)) {
            $wherec["t.menuID="] = "'" . $pluginId . "'";
        } else {
            $wherec["t.menuLink="] = "'" . $form . "'";
        }
        $other = array("orderBy" => "fieldIndex", "order" => "ASC");
        $dynamicFields = $this->CommonModel->GetMasterListDetails($selectC = 't.menuLink,t.menuID,t.quick_create_fields,d.*', 'menu_master', $wherec, '', '', $join, $other);
        //if(isset($dynamicFields) && !empty($dynamicFields)){
        $wheredata["menuID"] = $pluginId;
        $dynamicFieldsMeta = $this->CommonModel->getMasterDetails("menu_master", "metadata", $wheredata);

        $whereColData["menu_id"] = $pluginId;
        $whereColData["user_id"] = $this->input->post('SadminID');

        $dynamicColumnArrangement = $this->CommonModel->getMasterDetails("user_column_data", "c_metadata,m_metadata", $whereColData);
        //}
       if (isset($dynamicFields) && !empty($dynamicFields)) {
            // Attach options for local-list dropdown/radio/CheckboxList List List
            foreach ($dynamicFields as &$f) {
                if (isset($f->fieldType) && in_array(strtolower($f->fieldType), ['dropdown','radiolist','checkboxlist'], true) && $f->linkedWith !== NULL) {
                    $opts = $this->CommonModel->GetMasterListDetails(
                        $selectC = 'id as option_id, label, value_key, sort_order',
                        'dynamic_field_options',
                        ['field_id' => "='".$f->fieldID."'", 'is_active' => "= 1"],
                        '', '', [], ['orderBy' => 'sort_order', 'order' => 'ASC']
                    );
                    $f->options = $opts ?: [];
                }
                // For linkedWith, return metadata so UI can fetch from that table
                if (!empty($f->linkedWith)) {
                    $f->linkedMeta = [
                        'table'  => $f->linkedWith,
                        'label'  => $f->linkedDisplayColumn ?? null
                    ];
                }
            }
            unset($f);
            $status['data'] = $dynamicFields;
            $status['quick_create_fields'] = $dynamicFields[0]->quick_create_fields;

            if (isset($dynamicFieldsMeta[0]) && !empty($dynamicFieldsMeta[0])) {
                //$status['metadata'] = $dynamicFieldsMeta[0]->metadata;
                $status['metadata'] = $dynamicFields;
            }
            if (isset($loadFrom) && !empty($loadFrom)) {
                if (isset($dynamicColumnArrangement[0]->m_metadata) && !empty($dynamicColumnArrangement[0]->m_metadata) && $dynamicColumnArrangement[0]->m_metadata != '[]') {
                    $status['m_metadata'] = $dynamicColumnArrangement[0]->m_metadata;
                } else {
                    $status['m_metadata'] = $dynamicFields[0]->c_metadata;
                }
            } else {
                if (isset($dynamicColumnArrangement[0]->c_metadata) && !empty($dynamicColumnArrangement[0]->c_metadata) && $dynamicColumnArrangement[0]->c_metadata != '[]') {
                    $status['c_metadata'] = $dynamicColumnArrangement[0]->c_metadata;
                } else {
                    $status['c_metadata'] = null;
                }
            }
            $status['statusCode'] = 200;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['data'] = array();
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    public function getLinkedFormData()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $isAll = $this->input->post('getAll');
        $textSearch = $this->input->post('textSearch');
        $config = array();
        if (!isset($orderBy) || empty($orderBy)) {
            $orderBy = "menuName";
            $order = "ASC";
        }
        $other = array("orderBy" => $orderBy, "order" => $order);
        $config = $this->config->item('pagination');
        $wherec = $join = array();
        $wherec["status"] = " = 'active'";
        $wherec["isClick"] = "= 'yes'";
        $wherec["linked"] = "= 'y'";
        // get comapny access list
        $adminID = $this->input->post('SadminID');

        $join = array();
        $masterDetails = $this->CommonModel->GetMasterListDetails($selectC = '*', 'menu_master', $wherec, '', '', $join, $other);
        $status['data'] = $masterDetails;
        if ($masterDetails) {
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // c_metadata FOR DESKTOP
    public function updateColumnMetaDate()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $menuID = $this->input->post('menuId');
        $whereRecord = array(
            "menu_id" => $menuID,
            "user_id" => $this->input->post('SadminID'),
            "company_id" => $this->company_id,
        );
        $recordExist = $this->CommonModel->getMasterDetails('user_column_data', '', $whereRecord);
        if (isset($recordExist) && !empty($recordExist)) {
            $method = "POST";
        } else {
            $method = "PUT";
        }
        if ($method == "PUT") {
            $menuDetails['c_metadata'] = $this->validatedata->validate('htmlContent', 'Meta Data', false, '', array());
            $menuDetails['company_id'] = $this->company_id;
            $menuDetails['menu_id'] = $menuID;
            $menuDetails['user_id'] = $this->input->post('SadminID');
            $where = array('menu_id' => $menuID, 'user_id' => $this->input->post('SadminID'));
            $iscreated = $this->CommonModel->saveMasterDetails('user_column_data', $menuDetails);
            if (!$iscreated) {
                $status['msg'] = $this->systemmsg->getErrorCode(998);
                $status['statusCode'] = 998;
                $status['data'] = array();
                $status['flag'] = 'F';
                $this->response->output($status, 200);
            } else {
                $status['msg'] = $this->systemmsg->getSucessCode(400);
                $status['statusCode'] = 400;
                $status['data'] = array();
                $status['flag'] = 'S';
                $this->response->output($status, 200);
            }

        } else if ($method == "POST") {
            $menuDetails['c_metadata'] = $this->validatedata->validate('htmlContent', 'Meta Data', false, '', array());
            $menuDetails['company_id'] = $this->company_id;
            $where = array('menu_id' => $menuID, 'user_id' => $this->input->post('SadminID'));
            $iscreated = $this->CommonModel->updateMasterDetails('user_column_data', $menuDetails, $where);
            if (!$iscreated) {
                $status['msg'] = $this->systemmsg->getErrorCode(998);
                $status['statusCode'] = 998;
                $status['data'] = array();
                $status['flag'] = 'F';
                $this->response->output($status, 200);
            } else {
                $status['msg'] = $this->systemmsg->getSucessCode(400);
                $status['statusCode'] = 400;
                $status['data'] = array();
                $status['flag'] = 'S';
                $this->response->output($status, 200);
            }
        }
    }
    // c_metadata FOR DESKTOP
    public function saveCreateData()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $menuID = $this->input->post('menuId');
        $whereRecord = array("menuID" => $menuID);
        $recordExist = $this->CommonModel->getMasterDetails('menu_master', '', $whereRecord);
        $method = (isset($recordExist) && !empty($recordExist)) ? "POST" : "PUT";
        $menuDetails['quick_create_fields'] = $this->validatedata->validate('htmlContent', 'Meta Data', false, '', array());
        $iscreated = ($method == "PUT") ?
        $this->CommonModel->saveMasterDetails('menu_master', $menuDetails) :
        $this->CommonModel->updateMasterDetails('menu_master', $menuDetails, $whereRecord);
        if (!$iscreated) {
            $status['msg'] = $this->systemmsg->getErrorCode(998);
            $status['statusCode'] = 998;
            $status['data'] = array();
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getSucessCode(400);
            $status['statusCode'] = 400;
            $status['data'] = array();
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        }
    }
    // m_metadata FOR MOBILE
    public function updateMobileColumnMetaData()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $menuID = $this->input->post('menuId');
        $whereRecord = array(
            "menu_id" => $menuID,
            "user_id" => $this->input->post('SadminID'),
            "company_id" => $this->company_id,
        );
        $recordExist = $this->CommonModel->getMasterDetails('user_column_data', '', $whereRecord);
        if (isset($recordExist) && !empty($recordExist)) {
            $method = "POST";
        } else {
            $method = "PUT";
        }
        if ($method == "PUT") {
            $menuDetails['m_metadata'] = $this->validatedata->validate('htmlContent', 'Meta Data', false, '', array());
            $menuDetails['company_id'] = $this->company_id;
            $menuDetails['menu_id'] = $menuID;
            $menuDetails['user_id'] = $this->input->post('SadminID');

            $where = array('menu_id' => $menuID, 'user_id' => $this->input->post('SadminID'));
            $iscreated = $this->CommonModel->saveMasterDetails('user_column_data', $menuDetails);
            if (!$iscreated) {
                $status['msg'] = $this->systemmsg->getErrorCode(998);
                $status['statusCode'] = 998;
                $status['data'] = array();
                $status['flag'] = 'F';
                $this->response->output($status, 200);
            } else {
                $status['msg'] = $this->systemmsg->getSucessCode(400);
                $status['statusCode'] = 400;
                $status['data'] = array();
                $status['flag'] = 'S';
                $this->response->output($status, 200);
            }

        } else if ($method == "POST") {
            $menuDetails['m_metadata'] = $this->validatedata->validate('htmlContent', 'Meta Data', false, '', array());
            $menuDetails['company_id'] = $this->company_id;

            $where = array('menu_id' => $menuID, 'user_id' => $this->input->post('SadminID'));
            $iscreated = $this->CommonModel->updateMasterDetails('user_column_data', $menuDetails, $where);
            if (!$iscreated) {
                $status['msg'] = $this->systemmsg->getErrorCode(998);
                $status['statusCode'] = 998;
                $status['data'] = array();
                $status['flag'] = 'F';
                $this->response->output($status, 200);
            } else {
                $status['msg'] = $this->systemmsg->getSucessCode(400);
                $status['statusCode'] = 400;
                $status['data'] = array();
                $status['flag'] = 'S';
                $this->response->output($status, 200);
            }
        }
    }

    public function deleteUserColumnData()
    {
        // $sql = "UPDATE ab_admin SET user_setting = null WHERE adminID = 2 ";
        // $sql = "ALTER TABLE ab_customer MODIFY COLUMN assignee INT NULL;";
        // $this->datatables->remove_column('dynamic_leads', 'event_type'); 
        $where = array('fieldID' => 51);
        $this->CommonModel->deleteMasterDetails("dynamic_fields", $where);
        // $res = $this->db->query($sql);
        // $sql = "DELETE FROM ab_menu_master WHERE menuID = 117 ";
        // $res = $this->db->query($sql);
        // $sql = "DELETE FROM ab_invoice_header";
        // $sql2 = "DELETE FROM ab_invoice_line";
        // $sql3 = "DELETE FROM ab_receipts";
        // $res = $this->db->query($sql);
        // $res = $this->db->query($sql2);
        // $res = $this->db->query($sql3);
        // print_r($res);exit;
    }

    /** Normalize a label to a machine key (male -> male, "Credit Card" -> credit_card) */
    private function normalize_option_key($label) {
        $key = trim(mb_strtolower($label));
        $key = preg_replace('/\s+/', '_', $key);
        $key = preg_replace('/[^a-z0-9_]/', '', $key);
        return $key ?: substr(md5($label), 0, 12);
    }

    /** Upsert options list (CSV) into ab_dynamic_field_options; soft-delete missing */
    private function sync_field_options($fieldId, $csvOrArray) {
        // Accept CSV string or array
        $list = is_array($csvOrArray) ? $csvOrArray : explode(',', (string)$csvOrArray);
        $labels = [];
        foreach ($list as $i => $raw) {
            $label = trim((string)$raw);
            if ($label !== '') $labels[] = ['label' => $label, 'sort_order' => $i];
        }
        // Build maps
        $newKeys = [];
        foreach ($labels as $row) {
            $newKeys[$this->normalize_option_key($row['label'])] = $row;
        }

        // Fetch existing
        $existing = $this->CommonModel->getMasterDetails('dynamic_field_options', '', ['field_id' => $fieldId]);
        $existMap = [];
        foreach ($existing as $e) $existMap[$e->value_key] = $e;

        // Upsert present
        foreach ($newKeys as $key => $row) {
            if (isset($existMap[$key])) {
                // Update label/sort/is_active
                $this->CommonModel->updateMasterDetails(
                    'dynamic_field_options',
                    ['label' => $row['label'], 'sort_order' => $row['sort_order'], 'is_active' => 1],
                    ['id' => $existMap[$key]->id]
                );
            } else {
                $this->CommonModel->saveMasterDetails(
                    'dynamic_field_options',
                    [
                        'field_id'   => $fieldId,
                        'value_key'  => $key,
                        'label'      => $row['label'],
                        'sort_order' => $row['sort_order'],
                        'is_active'  => 1
                    ]
                );
            }
        }
        // Soft-hide options no longer present
        if (!empty($existing)) {
            $keep = array_keys($newKeys);
            if (count($keep)) {
                $this->db->where('field_id', $fieldId);
                $this->db->where_not_in('value_key', $keep);
                $this->db->update('dynamic_field_options', ['is_active' => 0]);
            } else {
                // No keepers → deactivate all
                $this->CommonModel->updateMasterDetails('dynamic_field_options', ['is_active' => 0], ['field_id' => $fieldId]);
            }
        }
    }
}
