<?php
defined('BASEPATH') or exit('No direct script access allowed');

class TaskDashboard extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->model('CommonModel');
        $this->load->model('DashboardModel');
    }
    // PRIORITY-WISE TASKS
    public function priorityWiseTasks()
    {
        // $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $data = $lables = $amounts = $bgColors = $borderColors = [];
        $categoryList = $this->DashboardModel->getCategoryBySlug('task_priority');
        foreach ($categoryList as $value) {
            $tasks = $this->DashboardModel->getTasksCount(['task_priority' => $value->category_id]);
            $lables[] = $value->categoryName;
            $amounts[] = (isset($tasks[0]->amount) && !empty($tasks[0]->amount)) ? $tasks[0]->amount : 0;
            $bgColors[] = $value->cat_color;
        }
        $data['current']['title'] = 'Priority Wise Task';
        $data['current']['lables'] = $lables;
        $data['current']['amounts'] = $amounts;
        $data['current']['bgColors'] = $bgColors;
        if ($data) {
            $status['data'] = $data;
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // PROJECT-WISE TASKS
    public function projectWiseTasks()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $data = array();
        $select = 'project_id,title';
        $whereT = array();
        $whereT['related_to'] = 'project';
        $projectlist = $this->CommonModel->GetMasterListDetails($select, 'projects');
        $categoryList = $this->DashboardModel->getCategoryBySlug('task_status');
        foreach ($projectlist as $project) {
            $data = array();
            $project->totalAmount = 0;
            foreach ($categoryList as $category) {
                $tasks = $this->DashboardModel->getTasksCount(['project_id' => $project->project_id, 'task_status' => $category->category_id]);
                $obj['amount'] = $tasks[0]->amount;
                $project->totalAmount = $tasks[0]->amount;
                $obj['lable'] = $category->categoryName;
                $obj['bgColor'] = $category->cat_color;
                $data[] = (Object) $obj;
            }
            $project->data = $data;
        }
        if (!empty($projectlist)) {
            $status['data']['project_wise_tasks'] = $projectlist;
            $status['msg'] = "success";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = "No data found";
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // ASSIGNEE-WISE TASKS
    public function assigneeWiseTasks()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $select = 'name,adminID';
        $assigneelist = $this->CommonModel->GetMasterListDetails($select, 'admin');
        $categoryList = $this->DashboardModel->getCategoryBySlug('task_status');
        foreach ($assigneelist as $assignee) {
            $assignee->totalAmount = 0;
            $data = array();
            foreach ($categoryList as $category) {
                $tasks = $this->DashboardModel->getTasksCount(['assignee' => $assignee->adminID, 'task_status' => $category->category_id]);
                $obj['amount'] = $tasks[0]->amount;
                $assignee->totalAmount = $tasks[0]->amount;
                $obj['lable'] = $category->categoryName;
                $obj['bgColor'] = $category->cat_color;
                $data[] = (Object) $obj;
            }
            $assignee->data = $data;
        }
        if (!empty($assigneelist)) {
            $status['data']['assignee_wise_tasks'] = $assigneelist;
            $status['msg'] = "success";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = "No data found";
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // CUSTOMER-WISE TASKS
    public function customerWiseTasks()
    {
        // $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $select = 'name,customer_id';
        $customerlist = $this->CommonModel->GetMasterListDetails($select, 'customer', array('status = ' => '"active"', 'type = ' => '"customer"'));
        $categoryList = $this->DashboardModel->getCategoryBySlug('task_status');
        foreach ($customerlist as $customer) {
            $data = array();
            $customer->totalAmount = 0;
            foreach ($categoryList as $category) {
                $tasks = $this->DashboardModel->getTasksCount(['customer_id' => $customer->customer_id, 'task_status' => $category->category_id]);
                $obj['amount'] = $tasks[0]->amount;
                $customer->totalAmount += $tasks[0]->amount;
                $obj['lable'] = $category->categoryName;
                $obj['bgColor'] = $category->cat_color;
                $data[] = (Object) $obj;
            }
            $customer->data = $data;
        }
        $status['data']['customer_wise_tasks'] = $customerlist;    
        $status['msg'] = "success";
        $status['statusCode'] = 400;
        $status['flag'] = 'S';
        $this->response->output($status, 200);
    }
    // ASSIGNEE-WISE TASKS
    public function assigneeWiseTaskRatio()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $select = 'name,adminID';
        $assigneelist = $this->CommonModel->GetMasterListDetails($select, 'admin');
        $categoryList = $this->DashboardModel->getCategoryBySlug('task_status');
        foreach ($assigneelist as $assignee) {
            $assignee->totalAmount = 0;
            foreach ($categoryList as $category) {
                $tasks = $this->DashboardModel->getTasksCount(['assignee' => $assignee->adminID, 'task_status' => $category->category_id]);
                $assignee->totalAmount = $assignee->totalAmount + $tasks[0]->amount;
                if ($category->slug == 'task_complete') {
                    $assignee->completedTask = $tasks[0]->amount;
                }
            }
            if ($assignee->completedTask != 0 && $assignee->totalAmount != 0) {
                $assignee->completionRatio = ($assignee->completedTask / $assignee->totalAmount) * 100;
            } else {
                $assignee->completionRatio = 0;
            }
        }
        $status['data']['assignee_wise_tasks'] = $assigneelist;
        $status['msg'] = "success";
        $status['statusCode'] = 400;
        $status['flag'] = 'S';
        $this->response->output($status, 200);
    }
    // TASKS COMPLETION RATIO
    public function taskCompletionRatio()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $categoryList = $this->DashboardModel->getCategoryBySlug('task_status');
        $totaltasks = $this->DashboardModel->getTasksCount([]);
        foreach ($categoryList as $key => $category) {
            if ($category->slug == 'task_complete') {
                $completedtasks = $this->DashboardModel->getTasksCount(['task_status' => $category->category_id]);
                break;
            }
        }
        if ($completedtasks[0]->amount != 0 && $totaltasks[0]->amount != 0) {
            $taskCompletionRatio = ( $completedtasks[0]->amount / $totaltasks[0]->amount) * 100;
        } else {
            $taskCompletionRatio = 0;
        }
        
        $status['data']['task_completion_ratio'] = $taskCompletionRatio;
        $status['data']['totaltasks'] = $totaltasks;
        $status['data']['completedtasks'] = $completedtasks;
        $status['msg'] = "success";
        $status['statusCode'] = 400;
        $status['flag'] = 'S';
        $this->response->output($status, 200);
    }
}
