<?php defined('BASEPATH') or exit('No direct script access allowed');
class IncomeDashboard extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->model('CommonModel');
        $this->load->model('DashboardModel');
    }
    // INCOME
    public function income()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $period_type = $this->input->post('period_type');
        $interval = $this->input->post('interval');
        $data = $lables = $amounts = [];
        $now = new DateTime();
        switch ($period_type) {
            case 'day':
                $lastDay = clone $now;
                $lastDay->modify('-6 days');
                for ($i = 1; $i <= 7; $i++) {
                    $lables[] = $lastDay->format('d M');
                    $incomeDate = $lastDay->format('Y-m-d'); //date("Y-m-d",strtotime($l_monday));
                    $det = $this->DashboardModel->incomeByDate($incomeDate);
                    $amounts[] = (isset($det[0]->amount) && !empty($det[0]->amount)) ? $det[0]->amount : 0;
                    $lastDay->modify('+1 day');
                }
                $data['current']['lables'] = $lables;
                $data['current']['amounts'] = $amounts;
                $data['current']['title'] = 'Last 7 Days';
                break;
            case 'current_week':
                $l_monday = clone $now;
                $l_monday = $l_monday->modify('monday');
                $data['current'] = $this->getWeeksData('income', $l_monday, $interval);
                $data['current']['title'] = 'Current week';
                $p_l_monday = clone $now;
                $p_l_monday = $p_l_monday->modify('last monday');
                $data['last'] = $this->getWeeksData('income', $p_l_monday);
                $data['last']['title'] = 'Last week';
                break;
            case 'current_month':
                // CURRENT MONTH
                $current_month = clone $now;
                $current_month->modify('first day of this month');
                $current_month_end = clone $now;
                $current_month_end->modify('last day of this month');
                $data['current'] = $this->getDataWeekWise('income', $current_month, $current_month_end);
                $data['current']['title'] = 'Current month';
                // LAST MONTH
                $last_month = clone $now;
                $last_month->modify('first day of last month');
                $last_month_end = clone $now;
                $last_month_end->modify('last day of last month');

                $data['last'] = $this->getDataWeekWise('income', $last_month, $last_month_end);
                $data['last']['title'] = 'Last month';

                break;
            case 'current_quarter':
                $currentMonth = clone $now;
                $iteration = 4;

                $currentMonth = $currentMonth->modify('-' . $iteration . ' months');
                for ($i = 0; $i < $iteration; $i++) {
                    $firstDate = $currentMonth->modify('first day of this month');
                    $lastDate = $currentMonth->modify('last day of this month');
                    $lables[] = $firstDate->format('M');
                    $startDate = $firstDate->format('Y-m-d');
                    $endDate = $lastDate->format('Y-m-d');
                    $det = $this->DashboardModel->incomeByMonths($startDate, $endDate);
                    $amounts[] = (isset($det[0]->amount) && !empty($det[0]->amount)) ? $det[0]->amount : 0;
                    $currentMonth = $lastDate;
                    $currentMonth->modify('+1 day');
                }

                $data['current']['amounts'] = $amounts;
                $data['current']['lables'] = $lables;
                $data['current']['title'] = 'Current Quarter';
                break;
            case 'current_fin_year':
                $currentMonth = clone $now;
                $iteration = 12;
                $currentMonth->modify('first day of January this year');
                for ($i = 0; $i < $iteration; $i++) {
                    $firstDate = $currentMonth->modify('first day of this month');
                    $lastDate = $currentMonth->modify('last day of this month');
                    $lables[] = $firstDate->format('M');
                    $startDate = $firstDate->format('Y-m-d'); //date("Y-m-d",strtotime($l_monday));
                    $endDate = $lastDate->format('Y-m-d'); //date("Y-m-d",strtotime($l_monday));
                    $det = $this->DashboardModel->incomeByMonths($startDate, $endDate);
                    $amounts[] = (isset($det[0]->amount) && !empty($det[0]->amount)) ? $det[0]->amount : 0;
                    $currentMonth = $lastDate;
                    $currentMonth->modify('+1 day');
                }

                $data['current']['amounts'] = $amounts;
                $data['current']['lables'] = $lables;
                $data['current']['title'] = 'Current Financial Year';
                break;
            default:
                break;
        }
        if ($data) {
            $status['data'] = $data;
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // EXPENSES
    public function expenses()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $period_type = $this->input->post('period_type');
        $interval = $this->input->post('interval');
        $data = $lables = $amounts = [];
        $now = new DateTime();
        switch ($period_type) {
            case 'day':
                $lastDay = clone $now;
                $lastDay->modify('-6 days');
                for ($i = 1; $i <= 7; $i++) {
                    $lables[] = $lastDay->format('d M');
                    $incomeDate = $lastDay->format('Y-m-d'); //date("Y-m-d",strtotime($l_monday));
                    $det = $this->DashboardModel->expenseByDate($incomeDate);
                    $amounts[] = (isset($det[0]->amount) && !empty($det[0]->amount)) ? $det[0]->amount : 0;
                    $lastDay->modify('+1 day');
                    $color = $this->generateRandomColor($i - 1);
                }
                $data['current']['lables'] = $lables;
                $data['current']['amounts'] = $amounts;
                $data['current']['title'] = 'Last 7 Days';
                break;
            case 'current_week':
                $l_monday = clone $now;
                $l_monday = $l_monday->modify('monday');
                $data['current'] = $this->getWeeksData('expense', $l_monday, $interval);
                $data['current']['title'] = 'Current week';
                $p_l_monday = clone $now;
                $p_l_monday = $p_l_monday->modify('last monday');
                $data['last'] = $this->getWeeksData('expense', $p_l_monday);
                $data['last']['title'] = 'Last week';
                break;
            case 'current_month':
                // CURRENT MONTH
                $current_month = clone $now;
                $current_month->modify('first day of this month');
                $current_month_end = clone $now;
                $current_month_end->modify('last day of this month');
                $data['current'] = $this->getDataWeekWise('expense', $current_month, $current_month_end);
                $data['current']['title'] = 'Current month';
                // LAST MONTH
                $last_month = clone $now;
                $last_month->modify('first day of last month');
                $last_month_end = clone $now;
                $last_month_end->modify('last day of last month');

                $data['last'] = $this->getDataWeekWise('expense', $last_month, $last_month_end);
                $data['last']['title'] = 'Last month';

                break;
            case 'current_quarter':
                $currentMonth = clone $now;
                $iteration = 4;
                $currentMonth = $currentMonth->modify('-' . $iteration . ' months');
                for ($i = 0; $i < $iteration; $i++) {
                    $firstDate = clone $currentMonth;
                    $firstDate->modify('first day of this month');
                    $lastDate = clone $currentMonth;
                    $lastDate = $lastDate->modify('last day of this month');
                    $startDate = $firstDate->format('Y-m-d');
                    $lables[] = $firstDate->format('M');
                    $endDate = $lastDate->format('Y-m-d');
                    $det = $this->DashboardModel->expenseByMonths($startDate, $endDate);
                    $amounts[] = (isset($det[0]->amount) && !empty($det[0]->amount)) ? $det[0]->amount : 0;
                    $currentMonth = $lastDate;
                    $currentMonth->modify('+1 day');
                }
                $data['current']['amounts'] = $amounts;
                $data['current']['lables'] = $lables;
                $data['current']['title'] = 'Current Quarter';
                break;
            case 'current_fin_year':
                $currentMonth = clone $now;
                $iteration = 12;
                $currentMonth->modify('first day of January this year');
                for ($i = 0; $i < $iteration; $i++) {
                    $firstDate = clone $currentMonth;
                    $firstDate->modify('first day of this month');
                    $lastDate = clone $currentMonth;
                    $lastDate = $lastDate->modify('last day of this month');
                    $lables[] = $firstDate->format('M');
                    $startDate = $firstDate->format('Y-m-d');
                    $endDate = $lastDate->format('Y-m-d');
                    $det = $this->DashboardModel->expenseByMonths($startDate, $endDate);
                    $amounts[] = (isset($det[0]->amount) && !empty($det[0]->amount)) ? $det[0]->amount : 0;
                    $currentMonth = $lastDate;
                    $currentMonth->modify('+1 day');
                }

                $data['current']['amounts'] = $amounts;
                $data['current']['lables'] = $lables;
                $data['current']['title'] = 'Current Financial Year';
                break;
            default:
                break;
        }
        if ($data) {
            $status['data'] = $data;
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // EXPENSES
    public function incomeAndExpense()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $period_type = $this->input->post('period_type');
        $chart_type = $this->input->post('chart_type');
        $interval = $this->input->post('interval');
        $data = $lables = $amounts_i = $amounts_e = [];
        $now = new DateTime();
        switch ($period_type) {
            case 'day':
                $lastDay = clone $now;
                $lastDay->modify('-6 days');
                for ($i = 1; $i <= 7; $i++) {
                    $lables[] = $lastDay->format('d M');
                    $incomeDate = $lastDay->format('Y-m-d'); //date("Y-m-d",strtotime($l_monday));
                    $det_i = $this->DashboardModel->incomeByDate($incomeDate);
                    $det_e = $this->DashboardModel->expenseByDate($incomeDate);
                    $amounts_i[] = (isset($det_i[0]->amount) && !empty($det_i[0]->amount)) ? $det_i[0]->amount : 0;
                    $amounts_e[] = (isset($det_e[0]->amount) && !empty($det_e[0]->amount)) ? $det_e[0]->amount : 0;
                    $lastDay->modify('+1 day');
                }
                $data['current']['lables'] = $lables;
                $data['current']['amounts'] = $amounts_i;
                $data['current']['title'] = 'Income';

                $data['last']['lables'] = $lables;
                $data['last']['amounts'] = $amounts_e;
                $data['last']['title'] = 'Expenses';
                break;
            case 'current_week':
                $l_monday = clone $now;
                $l_monday = $l_monday->modify('monday');
                $data['current'] = $this->getWeeksData('income', $l_monday, $interval);
                $data['current']['title'] = 'Income';

                $data['last'] = $this->getWeeksData('expense', $l_monday, $interval);
                $data['last']['title'] = 'Expenses';

                break;
            case 'current_month':
                // CURRENT MONTH
                $current_month = clone $now;
                $current_month_end = clone $now;
                $s1 = clone $current_month;
                $s2 = clone $current_month;
                $s1->modify('first day of this month');
                $s2->modify('first day of this month');
                $e1 = $current_month;
                $e2 = $current_month;
                $e1 = $current_month_end->modify('last day of this month');
                $e1 = $current_month_end->modify('last day of this month');
                $data['current'] = $this->getDataWeekWise('income', $s1, $e1);
                $data['current']['title'] = 'Income';
                $data['last'] = $this->getDataWeekWise('expense', $s2, $e2);
                $data['last']['title'] = 'Expense';
                break;
            case 'current_quarter':
                $currentMonth = clone $now;
                $iteration = 4;
                $bgColors = $borderColors = array();
                $currentMonth = $currentMonth->modify('-' . $iteration . ' months');
                for ($i = 0; $i < $iteration; $i++) {
                    $firstDate = clone $currentMonth;
                    $firstDate->modify('first day of this month');
                    $lastDate = clone $currentMonth;
                    $lastDate = $lastDate->modify('last day of this month');
                    $startDate = $firstDate->format('Y-m-d');
                    $lables[] = $firstDate->format('M');
                    $endDate = $lastDate->format('Y-m-d');
                    $det_i = $this->DashboardModel->incomeByMonths($startDate, $endDate);
                    $det_e = $this->DashboardModel->expenseByMonths($startDate, $endDate);
                    $amounts_i[] = (isset($det_i[0]->amount) && !empty($det_i[0]->amount)) ? $det_i[0]->amount : 0;
                    $amounts_e[] = (isset($det_e[0]->amount) && !empty($det_e[0]->amount)) ? $det_e[0]->amount : 0;
                    $currentMonth = $lastDate;
                    $currentMonth->modify('+1 day');
                }
                $data['current']['amounts'] = $amounts_i;
                $data['current']['lables'] = $lables;
                $data['current']['title'] = 'Income';

                $data['last']['amounts'] = $amounts_e;
                $data['last']['lables'] = $lables;
                $data['last']['title'] = 'Expense';
                break;
            case 'current_fin_year':
                $currentMonth = clone $now;
                $iteration = 12;
                $currentMonth->modify('first day of January this year');
                for ($i = 0; $i < $iteration; $i++) {
                    $firstDate = clone $currentMonth;
                    $firstDate->modify('first day of this month');
                    $lastDate = clone $currentMonth;
                    $lastDate = $lastDate->modify('last day of this month');
                    $lables[] = $firstDate->format('M');
                    $startDate = $firstDate->format('Y-m-d');
                    $endDate = $lastDate->format('Y-m-d');
                    $det_i = $this->DashboardModel->incomeByMonths($startDate, $endDate);
                    $det_e = $this->DashboardModel->expenseByMonths($startDate, $endDate);
                    $amounts_i[] = (isset($det_i[0]->amount) && !empty($det_i[0]->amount)) ? $det_i[0]->amount : 0;
                    $amounts_e[] = (isset($det_e[0]->amount) && !empty($det_e[0]->amount)) ? $det_e[0]->amount : 0;
                    $currentMonth = $lastDate;
                    $currentMonth->modify('+1 day');
                }
                $data['current']['amounts'] = $amounts_i;
                $data['current']['lables'] = $lables;
                $data['current']['title'] = 'Income';

                $data['last']['amounts'] = $amounts_e;
                $data['last']['lables'] = $lables;
                $data['last']['title'] = 'Expense';
                break;
            default:
                break;
        }
        if ($data) {
            $status['data'] = $data;
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // PROFIT AND LOSS
    public function profitAndLoss()
    {
        // $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $period_type = $this->input->post('period_type');
        $chart_type = $this->input->post('chart_type');
        $interval = $this->input->post('interval');
        $data = $lables = $amounts_l = $amounts_p = [];

        $now = new DateTime();
        switch ($period_type) {
            case 'day':
                $lastDay = clone $now;
                $lastDay->modify('-6 days');
                $lables = $amounts_p = $amounts_l = [];
                for ($i = 1; $i <= 7; $i++) {
                    $lables[] = $lastDay->format('d M');
                    $incomeDate = $lastDay->format('Y-m-d');
                    $income = $this->DashboardModel->incomeByDate($incomeDate)[0]->amount ?? 0;
                    $expense = $this->DashboardModel->expenseByDate($incomeDate)[0]->amount ?? 0;
                    $profit = max(0, $income - $expense);
                    $loss = max(0, $expense - $income);
                    $amounts_p[] = $profit;
                    $amounts_l[] = $loss;
                    $lastDay->modify('+1 day');
                }
                $data['current'] = [
                    'lables' => $lables,
                    'amounts' => $amounts_p,
                    'title' => 'profit',
                ];
                $data['last'] = [
                    'lables' => $lables,
                    'amounts' => $amounts_l,
                    'title' => 'loss',
                ];
                break;
            case 'current_week':
                $l_monday = clone $now;
                $l_monday = $l_monday->modify('monday');

                $data['current'] = $this->getWeeksData('profit', $l_monday, $interval);
                $data['current']['title'] = 'Profit';

                $data['last'] = $this->getWeeksData('loss', $l_monday, $interval);
                $data['last']['title'] = 'Loss';

                break;
            case 'current_month':
                // CURRENT MONTH
                $current_month_start = (clone $now)->modify('first day of this month');
                $current_month_end = (clone $now)->modify('last day of this month');
                $current_month_start_p = (clone $now)->modify('first day of this month');
                $current_month_end_p= (clone $now)->modify('last day of this month');

                $data['current'] = $this->getDataWeekWise('profit', $current_month_start_p, $current_month_end_p);
                $data['current']['title'] = 'Profit';

                $data['last'] = $this->getDataWeekWise('loss', $current_month_start, $current_month_end);
                $data['last']['title'] = 'Loss';
                break;
            case 'current_quarter':
                $iteration = 4 ;
                $currentMonth = (clone $now)->modify('-' . $iteration . ' months');
                $lables = $amounts_p = $amounts_l = [];                
                for ($i = 0; $i < $iteration; $i++) {
                    $firstDate = (clone $currentMonth)->modify('first day of this month');
                    $lastDate = (clone $currentMonth)->modify('last day of this month');

                    $startDate = $firstDate->format('Y-m-d');
                    $endDate = $lastDate->format('Y-m-d');
                    $lables[] = $firstDate->format('M');
                    
                    $income = $this->DashboardModel->incomeByMonths($startDate, $endDate)[0]->amount ?? 0;
                    $expense = $this->DashboardModel->expenseByMonths($startDate, $endDate)[0]->amount ?? 0;
                    
                    $profit = max(0, $income - $expense);
                    $loss = max(0, $expense - $income);
                    $amounts_p[] = $profit;
                    $amounts_l[] = $loss;
                    $currentMonth = $lastDate->modify('+1 day');
                }
                $data['current'] = [
                    'amounts' => $amounts_p,
                    'lables' => $lables,
                    'title' => 'Profit',
                ];
                
                $data['last'] = [
                    'amounts' => $amounts_l,
                    'lables' => $lables,
                    'title' => 'Loss',
                ];
                break;
            case 'current_fin_year':
                $currentMonth = (clone $now)->modify('first day of January this year');
                $lables = $amounts_p = $amounts_l = [];
                $iteration = 12;
                for ($i = 0; $i < $iteration; $i++) {
                    $firstDate = (clone $currentMonth)->modify('first day of this month');
                    $lastDate = (clone $currentMonth)->modify('last day of this month');
                    $lables[] = $firstDate->format('M');
                    $startDate = $firstDate->format('Y-m-d');
                    $endDate = $lastDate->format('Y-m-d');
                    $income = $this->DashboardModel->incomeByMonths($startDate, $endDate)[0]->amount ?? 0;
                    $expense = $this->DashboardModel->expenseByMonths($startDate, $endDate)[0]->amount ?? 0;
                    $profit = max(0, $income - $expense);
                    $loss = max(0, $expense - $income);
                    $amounts_p[] = $profit;
                    $amounts_l[] = $loss;
                    $currentMonth = $lastDate->modify('+1 day');
                }
                $data['current'] = [
                    'amounts' => $amounts_p,
                    'lables' => $lables,
                    'title' => 'Profit',
                ];
                
                $data['last'] = [
                    'amounts' => $amounts_l,
                    'lables' => $lables,
                    'title' => 'Loss',
                ];
                break;
            default:
                break;
        }
        if ($data) {
            $status['data'] = $data;
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // ACCOUNT BALANCE
    public function accountBalance()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $account_id = $this->input->post('account_id');
        $where = array("account_id" => $account_id);
        $accountDetails = $this->CommonModel->getMasterDetails('accounts', '', $where);
        if (isset($accountDetails[0]) && !empty($accountDetails[0])) {
            $status['data']['account_balance'] = $accountDetails[0]->opening_bal;
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // OVER-DUE PAYMENTS
    public function overduePayments()
    {
        // $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $view_type = $this->input->post('view_type');
        $overduePayments = $this->DashboardModel->overduePayments();
        if (isset($overduePayments) && !empty($overduePayments)) {
            $status['data']['overduePayments'] = $overduePayments;
            $status['msg'] = "sucess";
            $status['statusCode'] = 400;
            $status['flag'] = 'S';
            $this->response->output($status, 200);
        } else {
            $status['msg'] = $this->systemmsg->getErrorCode(227);
            $status['statusCode'] = 227;
            $status['flag'] = 'F';
            $this->response->output($status, 200);
        }
    }
    // TOP 10 CUSTOMERS
    public function topTenCustomers()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $top10Customers = [];
        $top10Customers = $this->DashboardModel->getTopCustomers(10,'approved');
        $status['data']['top_10_customers'] = $top10Customers;
        $status['msg'] = "sucess";
        $status['statusCode'] = 400;
        $status['flag'] = 'S';
        $this->response->output($status, 200);
    }
    // TOP 10 CUSTOMERS
    public function revenueByCustomersTopThirty()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $top30Customers = [] ;
        $top30Customers = $this->DashboardModel->getTopCustomers(30,'');
        $status['data']['revenue_by_customers'] = $top30Customers;
        $status['msg'] = "sucess";
        $status['statusCode'] = 400;
        $status['flag'] = 'S';
        $this->response->output($status, 200);
    }
    // OUTSTANDING
    public function outstanding()
    {
        $this->access->checkTokenKey();
        $this->response->decodeRequest();
        $outstanding = [] ;
        $outstanding = $this->DashboardModel->getOutStading();
        // print_r('<pre>');
        foreach ($outstanding as $key => $customer) {
            $customer->paidPercentage = (( $customer->gross_amount - $customer->total_pending_amount) / $customer->gross_amount) * 100;
        }
        // print_r($outstanding);exit;

        $status['data']['outstanding'] = $outstanding;
        $status['msg'] = "sucess";
        $status['statusCode'] = 400;
        $status['flag'] = 'S';
        $this->response->output($status, 200);
    }
    public function getDataWeekWise($module, $week_start, $current_month_end)
    {
        $weeksData = $weeksLabels = $bgColors = $borderColors = [];
        $week_c = 1;
        while ($week_start <= $current_month_end) {
            $week_end = clone $week_start;
            $week_end->modify('next sunday');
            $startDate = $week_start->format('Y-m-d'); //date("Y-m-d",strtotime($l_monday));
            $endDate = $week_end->format('Y-m-d'); //date("Y-m-d",strtotime($l_monday));
            switch ($module) {
                case 'income':
                    $det = $this->DashboardModel->incomeByMonths($startDate, $endDate);
                    break;
                case 'expense':
                    $det = $this->DashboardModel->expenseByMonths($startDate, $endDate);
                    break;
                case 'profit':
                case 'loss':
                    $income = $this->DashboardModel->incomeByMonths($startDate, $endDate)[0]->amount ?? 0;
                    $expense = $this->DashboardModel->expenseByMonths($startDate, $endDate)[0]->amount ?? 0;
                    $profit = max(0, $income - $expense);
                    $loss = max(0, $expense - $income);
                    if ($module == 'profit') {
                        $weeksData[] = $profit;
                    } else {
                        $weeksData[] = $loss;
                    }
                    break;
                default:
                    break;
            }
            if ($module != 'profit' && $module != 'loss') {
                $weeksData[] = (isset($det[0]->amount) && !empty($det[0]->amount)) ? $det[0]->amount : 0;
            }
            $weeksLabels[] = 'Week ' . $week_c;
            $color = $this->generateRandomColor($week_c - 1);
            $bgColors[] = $color['bgColor'];
            $borderColors[] = $color['borderColor'];
            $week_start->modify('next monday');
            $week_c++;
        }
        return ['amounts' => $weeksData, 'lables' => $weeksLabels, 'bgColors' => $bgColors, 'borderColors' => $borderColors, 'week_count' => $week_c];
    }
    public function getWeeksData($module, $startDate, $interval = '')
    {
        $amounts = $lables = $bgColors = $borderColors = [];
        $interval = ($interval == '') ? 14 : 7;
        for ($i = 1; $i <= $interval; $i++) {
            $lables[] = $startDate->format('D');
            $incomeDate = $startDate->format('Y-m-d'); //date("Y-m-d",strtotime($l_monday));
            switch ($module) {
                case 'income':
                    $det = $this->DashboardModel->incomeByDate($incomeDate);
                    break;
                case 'expense':
                    $det = $this->DashboardModel->expenseByDate($incomeDate);
                    break;
                case 'profit':
                case 'loss':
                    $income = $this->DashboardModel->incomeByDate($incomeDate)[0]->amount ?? 0;
                    $expense = $this->DashboardModel->expenseByDate($incomeDate)[0]->amount ?? 0;
                    $profit = max(0, $income - $expense);
                    $loss = max(0, $expense - $income);
                    if ($module == 'profit') {
                        $amounts[] = $profit;
                    } else {
                        $amounts[] = $loss;
                    }
                    break;
                default:
                    break;
            }
            if ($module != 'profit' && $module != 'loss') {
                $amounts[] = (isset($det[0]->amount) && !empty($det[0]->amount)) ? $det[0]->amount : 0;
            }
            $startDate->modify('+1 day');
            // COLORS FOR PIE AND DOUGHNUT
            $color = $this->generateRandomColor($i - 1);
            $bgColors[] = $color['bgColor'];
            $borderColors[] = $color['borderColor'];
        }

        return ['lables' => $lables, 'amounts' => $amounts, 'bgColors' => $bgColors, 'borderColors' => $borderColors];
    }
    public function generateRandomColor($i)
    {
        $colors = [
            ['bgColor' => 'rgba(255, 94, 77, 0.6)', 'borderColor' => 'rgba(255, 94, 77, 1)'], // Sunset Orange
            ['bgColor' => 'rgba(255, 120, 68, 0.6)', 'borderColor' => 'rgba(255, 120, 68, 1)'], // Deep Coral
            ['bgColor' => 'rgba(255, 160, 58, 0.6)', 'borderColor' => 'rgba(255, 160, 58, 1)'], // Golden Hour
            ['bgColor' => 'rgba(255, 196, 87, 0.6)', 'borderColor' => 'rgba(255, 196, 87, 1)'], // Sunset Yellow
            ['bgColor' => 'rgba(255, 150, 180, 0.6)', 'borderColor' => 'rgba(255, 150, 180, 1)'], // Blush Pink
            ['bgColor' => 'rgba(203, 153, 201, 0.6)', 'borderColor' => 'rgba(203, 153, 201, 1)'], // Soft Lavender
            ['bgColor' => 'rgba(160, 100, 205, 0.6)', 'borderColor' => 'rgba(160, 100, 205, 1)'], // Twilight Purple
            ['bgColor' => 'rgba(255, 80, 90, 0.6)', 'borderColor' => 'rgba(255, 80, 90, 1)'], // Fiery Red
            ['bgColor' => 'rgba(255, 190, 128, 0.6)', 'borderColor' => 'rgba(255, 190, 128, 1)'], // Peach Glow
            ['bgColor' => 'rgba(255, 210, 140, 0.6)', 'borderColor' => 'rgba(255, 210, 140, 1)'], // Warm Sand
            ['bgColor' => 'rgba(248, 131, 121, 0.6)', 'borderColor' => 'rgba(248, 131, 121, 1)'], // Rose Red
            ['bgColor' => 'rgba(244, 117, 96, 0.6)', 'borderColor' => 'rgba(244, 117, 96, 1)'], // Ember Glow
            ['bgColor' => 'rgba(255, 94, 120, 0.6)', 'borderColor' => 'rgba(255, 94, 120, 1)'], // Soft Red
            ['bgColor' => 'rgba(250, 146, 81, 0.6)', 'borderColor' => 'rgba(250, 146, 81, 1)'], // Autumn Orange
            ['bgColor' => 'rgba(253, 212, 97, 0.6)', 'borderColor' => 'rgba(253, 212, 97, 1)'], // Golden Sunset
            ['bgColor' => 'rgba(227, 145, 114, 0.6)', 'borderColor' => 'rgba(227, 145, 114, 1)'], // Copper Rose
            ['bgColor' => 'rgba(218, 118, 152, 0.6)', 'borderColor' => 'rgba(218, 118, 152, 1)'], // Rosy Dusk
            ['bgColor' => 'rgba(206, 160, 205, 0.6)', 'borderColor' => 'rgba(206, 160, 205, 1)'], // Sunset Lavender
            ['bgColor' => 'rgba(173, 99, 192, 0.6)', 'borderColor' => 'rgba(173, 99, 192, 1)'], // Orchid Purple
            ['bgColor' => 'rgba(245, 135, 100, 0.6)', 'borderColor' => 'rgba(245, 135, 100, 1)'], // Soft Tangerine
        ];
        if ($i < count($colors)) {
            return $colors[$i];
        } else {
            return ['', ''];
        }
    }
}
