<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Barcodes extends CI_Controller
{

    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     *         http://example.com/index.php/welcome
     *    - or -
     *         http://example.com/index.php/welcome/index
     *    - or -
     * Since this controller is set as the default controller in
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     * @see https://codeigniter.com/user_guide/general/urls.html
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('CommonModel');
        $this->load->library("response");
        $this->load->library("Filters");
        $this->load->library('core/barcode');
    }

    public function print_barcodes()
    {
        // Example list (mix of strings and detailed items)
        $items = [
            'WS-10001',
            ['value' => 'WS-10002', 'title' => 'Laptop', 'subtext' => 'Dell 7410'],
            ['value' => 'WS-10003', 'title' => 'Desktop', 'subtext' => 'HP 400 G6'],
            // ...
        ];
        // Options override (optional)
        $opts = [
            'page_size'        => 'A4',
            'orientation'      => 'P',
            'cols'             => 3,
            'rows'             => 8,
            'label_width_mm'   => 70,
            'label_height_mm'  => 35,
            'logo_path'        => FCPATH.'assets/img/logo.png', // optional
            'barcode_type'     => 'code128',
            'width_factor'     => 2,
            'height_px'        => 48,
            'filename'         => 'asset-barcodes.pdf',
            // 'temp_dir'      => sys_get_temp_dir().'/mpdf', // if needed
        ];

        // Stream inline to browser (default)
        $this->barcode->generate($items, $opts);

        // OR save to server:
        // $path = FCPATH.'downloads/asset-barcodes.pdf';
        // $file = $this->barcode_label_pdf->generate($items, $opts, $path, \Mpdf\Output\Destination::FILE);
        // echo 'Saved to: '.$file;
    }
}
