<?php
defined('BASEPATH') or exit('No direct script access allowed');

class LoginTemplate extends CI_Controller
{

	/** 
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not categoryed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	var $columnNames = [
		"modified_by" => ["table" => "admin", "alias" => "am", "column" => "name", "key2" => "adminID"],
		"created_by" => ["table" => "admin", "alias" => "ad", "column" => "name", "key2" => "adminID"],			
	];
	var $customCol = [
		"company_id" => ["table" => "info_settings", "alias" => "dc", "column" => "companyName", "key2" => "infoID"],
	];
	function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->model('CommonModel');
		$this->load->library("pagination");
		$this->load->library("response");
		$this->load->library("ValidateData");
		$this->load->helper('directory');
		$this->load->library("Datatables");
		$this->load->library("Filters");
	}
	public function getTemplateDetails(){
		$this->response->decodeRequest();
		$this->menuID = $this->input->post('menuId');
		
		$adminID = $this->input->post('SadminID');
		$isAll = $this->input->post('getAll');
		$curPage = $this->input->post('curpage');
		$orderBy = $this->input->post('orderBy');
		$order = $this->input->post('order');
		$statuscode = $this->input->post('status');
		$config = $other = $wherec = $join = array();
		$config = $this->config->item('pagination');
		if($isAll !="Y"){
			$this->filters->_initialize();
			$wherec = $join = array();
			$wherec = $this->whereData["wherec"];
			$other = $this->whereData["other"];
			$join = $this->whereData["join"];
			$selectC = $this->whereData["select"];	
		}else{
			if (isset($statuscode) && !empty($statuscode)) {
				$statusStr = str_replace(",", '","', $statuscode);
				$wherec["t.status"] = 'IN ("' . $statusStr . '")';
			}
		}
		if (!isset($orderBy) || empty($orderBy)) {
			$orderBy = "slide_id";
			$order = "ASC";
		}
		$other["orderBy"] = $orderBy;
		$other["order"]= $order;
		$config["base_url"] = base_url() . "templateSlideDetails";
		$config["total_rows"] = $this->CommonModel->getCountByParameter('t.slide_id', 'application_branding', $wherec, $other);
		$config["uri_segment"] = 2;
		$this->pagination->initialize($config);
		if (isset($curPage) && !empty($curPage)) {
			$curPage = $curPage;
			$page = $curPage * $config["per_page"];
		} else {
			$curPage = 0;
			$page = 0;
		}
		if ($isAll == "Y") {
			$slideDetails = $this->CommonModel->GetMasterListDetails($selectC = '*', 'application_branding', $wherec, '', '', $join, $other);
		} else {
			$selectC = ($selectC != "") ? ''.$selectC : '';
			$slideDetails = $this->CommonModel->GetMasterListDetails($selectC, 'application_branding', $wherec, $config["per_page"], $page, $join, $other);
		}
		$status['data'] = $slideDetails;
		$status['paginginfo']["curPage"] = $curPage;
		$status['paginginfo']["prevPage"] = ($curPage <= 1) ? 0 : $curPage - 1 ;
		$status['paginginfo']["pageLimit"] = $config["per_page"];
		$status['paginginfo']["nextpage"] =  $curPage + 1;
		$status['paginginfo']["totalRecords"] =  $config["total_rows"];
		$status['paginginfo']["start"] =  $page;
		$status['paginginfo']["end"] =  $page + $config["per_page"];
		$status['loadstate'] = true;
		if ($config["total_rows"] <= $status['paginginfo']["end"]) {
			$status['msg'] = $this->systemmsg->getErrorCode(232);
			$status['statusCode'] = 400;
			$status['flag'] = 'S';
			$status['loadstate'] = false;
			$this->response->output($status, 200);
		}
		if ($slideDetails) {
			$status['msg'] = "sucess";
			$status['statusCode'] = 400;
			$status['flag'] = 'S';
			$this->response->output($status, 200);
		} else {
			$status['msg'] = $this->systemmsg->getErrorCode(227);
			$status['statusCode'] = 227;
			$status['flag'] = 'F';
			$this->response->output($status, 200);
		}
	}
	
	public function slideMaster($slide_id = ""){	

		$this->access->checkTokenKey();
		$this->response->decodeRequest();
		$this->menuID = $this->input->post('menuId');
		$method = $this->input->method(TRUE);

		if ($method == "POST" || $method == "PUT") {
			$slideDetails = array();
			$updateDate = date("Y/m/d H:i:s");
			$slideDetails['slide_id'] = $this->validatedata->validate('slide_id', 'slide ID', false, '', array());
			$slideDetails['title'] = $this->validatedata->validate('title', 'Name', false, '', array());
			$slideDetails['status'] = $this->validatedata->validate('status', 'status', false, '', array());
			$slideDetails['description'] = $this->validatedata->validate('description', 'Description', false, '', array());
			$slideDetails['image'] = $this->validatedata->validate('image',' Image',false,'',array());
			
			$menuDetails = $this->datatables->getMenuDetails($this->menuID);
    		$fieldData = $this->datatables->mapDynamicFeilds($menuDetails->menuLink, $this->input->post());
			
			if ($method == "PUT") {
				$slideDetails['created_by'] = $this->input->post('SadminID');
				$slideDetails['created_date'] = $updateDate;
				$slideDetails['modified_date'] = null;
				$this->db->trans_start();
				$iscreated = $this->CommonModel->saveMasterDetails('application_branding', $slideDetails);
				if (!$iscreated) {
					$this->db->trans_rollback();
					$status['msg'] = $this->systemmsg->getErrorCode(998);
					$status['statusCode'] = 998;
					$status['data'] = array();
					$status['flag'] = 'F';
					$this->response->output($status, 200);
				} else {
					$this->filters->upsertDynamicData();
					$this->db->trans_commit();
					$status['msg'] = $this->systemmsg->getSucessCode(400);
					$status['statusCode'] = 400;
					$status['data'] = array();
					$status['flag'] = 'S';
					$this->response->output($status, 200);
				}
			} elseif ($method == "POST") {
			
				$where = array('slide_id' => $slide_id);
				if (!isset($slide_id) || empty($slide_id)) {
					$status['msg'] = $this->systemmsg->getErrorCode(998);
					$status['statusCode'] = 998;
					$status['data'] = array();
					$status['flag'] = 'F';
					$this->response->output($status, 200);
				}
				$slideDetails['modified_by'] = $this->input->post('SadminID');
				$slideDetails['modified_date'] = $updateDate;
				$this->db->trans_start();
				$iscreated = $this->CommonModel->updateMasterDetails('application_branding', $slideDetails, $where);
				if (!$iscreated) {
					$this->db->trans_rollback();
					$status['msg'] = $this->systemmsg->getErrorCode(998);
					$status['statusCode'] = 998;
					$status['data'] = array();
					$status['flag'] = 'F';
					$this->response->output($status, 200);
				} else {
					$this->filters->upsertDynamicData($slide_id);
					$this->db->trans_commit();
					$status['msg'] = $this->systemmsg->getSucessCode(400);
					$status['statusCode'] = 400;
					$status['data'] = array();
					$status['flag'] = 'S';
					$this->response->output($status, 200);
				}
			} elseif ($method == "dele") {
				$slideDetails = array();
				$where = array('sID' => $sID);
				if (!isset($sID) || empty($sID)) {
					$status['msg'] = $this->systemmsg->getErrorCode(996);
					$status['statusCode'] = 996;
					$status['data'] = array();
					$status['flag'] = 'F';
					$this->response->output($status, 200);
				}

				$iscreated = $this->CommonModel->deleteMasterDetails('application_branding', $where);
				if (!$iscreated) {
					$status['msg'] = $this->systemmsg->getErrorCode(996);
					$status['statusCode'] = 996;
					$status['data'] = array();
					$status['flag'] = 'F';
					$this->response->output($status, 200);
				} else {
					$status['msg'] = $this->systemmsg->getSucessCode(400);
					$status['statusCode'] = 400;
					$status['data'] = array();
					$status['flag'] = 'S';
					$this->response->output($status, 200);
				}
			}
		} else {
			if($slide_id ==""){
				$status['msg'] = $this->systemmsg->getSucessCode(400);
				$status['statusCode'] = 400;
				$status['data'] =array();
				$status['flag'] = 'S';
				$this->response->output($status,200);
			}
			$this->filters->_initialize('yes');
			$wherec = $join = array();
			$wherec = $this->whereData["wherec"];
			$other = $this->whereData["other"];
			$join = $this->whereData["join"];
			$selectC = $this->whereData["select"];	
			$wherec["t.slide_id ="] = "'".$slide_id."'";	
			if ($selectC != "") {
				$selectC = "t.*," . $selectC;
			}
			$this->CommonModel->GetMasterListDetails($selectC, $this->menuDetails->table_name, $wherec, '', '', $join, array());
			if (isset($slideDetails) && !empty($slideDetails)) {
				$status['data'] = $slideDetails;
				$status['statusCode'] = 200;
				$status['flag'] = 'S';
				$this->response->output($status, 200);
			} else {
				$status['msg'] = $this->systemmsg->getErrorCode(227);
				$status['statusCode'] = 227;
				$status['data'] = array();
				$status['flag'] = 'F';
				$this->response->output($status, 200);
			}
		}
	}
	public function slideChangeStatus()
	{
		$this->access->checkTokenKey();
		$this->response->decodeRequest();
		$action = $this->input->post('action');
		if (trim($action) == "changeStatus") {
			$ids = $this->input->post("list");
			$statusCode = $this->input->post("status");
			$changestatus = $this->CommonModel->changeMasterStatus('application_branding', $statusCode, $ids, 'slide_id');

			if ($changestatus) {

				$status['data'] = array();
				$status['statusCode'] = 200;
				$status['flag'] = 'S';
				$this->response->output($status, 200);
			} else {
				$status['data'] = array();
				$status['msg'] = $this->systemmsg->getErrorCode(996);
				$status['statusCode'] = 996;
				$status['flag'] = 'F';
				$this->response->output($status, 200);
			}
		}
	}
	public function multiplelogintemplateChangeStatus(){
		$this->access->checkTokenKey();
		$this->response->decodeRequest();
		$action = $this->input->post("action");
		$ids = $this->input->post("list");
		$statusCode = $this->input->post("status");
		$menuId = $this->input->post("menuId");
		if (trim($action) == "delete") {
			$whereIn ['slide_id']= $ids;
			$changestatus = $this->CommonModel->multipleDeleteMasterDetails('application_branding', '',$whereIn);
		}else{
			$changestatus = $this->CommonModel->changeMasterStatus('application_branding', $action, $ids, 'slide_id');
		}
		if ($changestatus) {				
			$status['data'] = array();
			$status['statusCode'] = 200;
			$status['flag'] = 'S';
			$this->response->output($status, 200);
		} else {
			$this->response->outputErrorResponse(996);
		}
	}
}
