<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ErrorLog extends CI_Controller
{

	/** 
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not categoryed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	var $columnNames = [];
    var $customCol = [];

	function __construct(){
		parent::__construct();
		$this->load->database();
		$this->load->model('CommonModel');
		// $this->load->model('TraineeModel');
		$this->load->library("pagination");
		$this->load->library("response");
		$this->load->library("ValidateData");
		$this->load->helper('directory');
		$this->load->library("Datatables");
		$this->load->library("Filters");
	}
	public function getErrorLogDetailList(){
		$this->access->checkTokenKey();
		$this->response->decodeRequest();
		$this->menuID = $this->input->post('menuId');
		$adminID = $this->input->post('SadminID');
		$isAll = $this->input->post('getAll');
		$curPage = $this->input->post('curpage');
		$orderBy = $this->input->post('orderBy');
		$order = $this->input->post('order');
		$statuscode = $this->input->post('status');
		$config = $wherec = $join = array();
		$config = $this->config->item('pagination');
		if($isAll !="Y"){		
			$this->filters->_initialize();
			$wherec = $join = array();
			$wherec = $this->whereData["wherec"];
			$other = $this->whereData["other"];
			$join = $this->whereData["join"];
			$selectC = $this->whereData["select"];	
		}else{
			if (isset($statuscode) && !empty($statuscode)) {
				$statusStr = str_replace(",", '","', $statuscode);
				$wherec["t.status"] = 'IN ("' . $statusStr . '")';
			}
		}
		if (!isset($orderBy) || empty($orderBy)) {
			$orderBy = "errorID";
			$order = "ASC";
		}
		$other["orderBy"] = $orderBy;
		$other["order"]= $order;
		$config["base_url"] = base_url() . "errorLogDetails";
		$config["total_rows"] = $this->CommonModel->getCountByParameter('t.errorID', 'error_logs', $wherec, $other);
		$config["uri_segment"] = 2;
		$this->pagination->initialize($config);
		if (isset($curPage) && !empty($curPage)) {
			$curPage = $curPage;
			$page = $curPage * $config["per_page"];
		} else {
			$curPage = 0;
			$page = 0;
		}
		if ($isAll == "Y") {
			$errorLogDetails = $this->CommonModel->GetMasterListDetails($selectC = '*', 'error_logs', $wherec, '', '', $join, $other);
		} else {
			$selectC = ($selectC != "") ? 't.*,'.$selectC : 't.*';
			$errorLogDetails = $this->CommonModel->GetMasterListDetails($selectC, 'error_logs', $wherec, $config["per_page"], $page, $join, $other);
		}
		$status['data'] = $errorLogDetails;
		$status['paginginfo']["curPage"] = $curPage;
		$status['paginginfo']["prevPage"] = ($curPage <= 1) ? 0 : $curPage - 1;
		$status['paginginfo']["pageLimit"] = $config["per_page"];
		$status['paginginfo']["nextpage"] =  $curPage + 1;
		$status['paginginfo']["totalRecords"] =  $config["total_rows"];
		$status['paginginfo']["start"] =  $page;
		$status['paginginfo']["end"] =  $page + $config["per_page"];
		$status['loadstate'] = true;
		if ($config["total_rows"] <= $status['paginginfo']["end"]) {
			$status['msg'] = $this->systemmsg->getErrorCode(232);
			$status['statusCode'] = 400;
			$status['flag'] = 'S';
			$status['loadstate'] = false;
			$this->response->output($status, 200);
		}
		if ($errorLogDetails) {
			$status['msg'] = "sucess";
			$status['statusCode'] = 400;
			$status['flag'] = 'S';
			$this->response->output($status, 200);
		} else {
			$status['msg'] = $this->systemmsg->getErrorCode(227);
			$status['statusCode'] = 227;
			$status['flag'] = 'F';
			$this->response->output($status, 200);
		}
	}
	public function getErrorLogDetails($errorID = ""){
		$this->access->checkTokenKey();
		$this->response->decodeRequest();
		$method = $this->input->method(TRUE);
		$where = array("errorID" => $errorID);
		$errorDetails = $this->CommonModel->getMasterDetails('error_logs', '', $where);
		if (isset($errorDetails) && !empty($errorDetails)) {
			$status['data'] = $errorDetails;
			$status['statusCode'] = 200;
			$status['flag'] = 'S';
			$this->response->output($status, 200);
		} else {

			$status['msg'] = $this->systemmsg->getErrorCode(227);
			$status['statusCode'] = 227;
			$status['data'] = array();
			$status['flag'] = 'F';
			$this->response->output($status, 200);
		}
	}
}
